<?php

//  AME Autmoatic Media Embedder 2.0.0
//	Copyright 2008 All rights reserved by sweetsquared.com
//	This code may not be used in whole or part without explicit written
//	permission from Samuel Sweet at sweetsquared.com.
//  You may not distribute this or any of the associated files in whole or significant part
//	without explicit written permission from Samuel Sweet at sweetsquared.com



/**
 * Strips [ame] code from text
 *
 * @param 	string $text
 * @return 	string
 */
function ame_strip(&$text)
{
	$find = array("%\[ame\](.*?)\[/ame\]%im",
		"%\[ame=(.*?)\](.*?)(?:@@AMEPARAM@@.*)?\[/ame\]%im");
	$replace = array('[url]\1[/url]', '[url=\1]\2[/url]');
	//$test = preg_replace($find, $replace, $text);
	return preg_replace($find, $replace, $text);
}

/**
 * Caches a key value pair for prepping bbcode. Gets ALL matches
 *
 * @return array	regexp, replacements array
 */
function &fetch_full_ameinfo($findonly = false)
{
	global $db, $vbulletin, $vbphrase, $stylevar;
	static $ameinfo = array();
	static $inied, $lastfind;

	if ($lastfind && !$findonly)
	{
		$inied = false;
		$ameinfo = array();
	}

	if (!$inied)
	{
		if ($vbulletin->options['automediaembed_resolve'])
		{
			$embed = ",IF(extraction=1 AND embedregexp!= '', embedregexp, '') as embedregexp";
			$embedwhere = " AND ((extraction = 0 AND embedregexp = '') OR (extraction = 1)) ";
		}
		else
		{
			$embedwhere = " AND embedregexp = ''";
		}


		$sql = "SELECT findcode" . (!$findonly ? ", replacecode,title,container" : ",extraction$embed") . " FROM " . TABLE_PREFIX . "automediaembed WHERE status=1 $embedwhere
						ORDER BY displayorder, title ASC";
		$results = $db->query_read_slave($sql);

		while ($result = $db->fetch_array($results))
		{
			if ($result['findcode'])
			{

				if (!$findonly)
				{

					$ameinfo['find'][] = "~($result[findcode])~ie";
					$ameinfo['replace'][] = 'ame_match_bbcode($param1, $param2, \'' . $result['title'] . '\', ' . $result['container'] . ', \'' . addslashes($result['replacecode']) . '\', \'\\1\', \'\\2\', \'\\3\', \'\\4\', \'\\5\', \'\\6\')';


				}
				else
				{

						$ameinfo['find'][] = "~(\[url\]$result[findcode]\[/url\])~ie";
						$ameinfo['find'][] = "~(\[url=\"?$result[findcode]\"?\](.*?)\[/url\])~ie";
						$ameinfo['replace'][] = 'ame_match("\1", "", ' . intval($result['extraction']) .', "' . ($result['embedregexp'] ? "~" . addslashes($result['embedregexp']) . "~sim" : "") . '", $ameinfo)';
						$ameinfo['replace'][] = 'ame_match("\1", "\2", ' . intval($result['extraction']) .', "' . ($result['embedregexp'] ? "~" . addslashes($result['embedregexp']) . "~sim" : "") . '", $ameinfo)';

				}

			}
		}

		$inied = true;
	}

	$lastfind = $findonly;

	return $ameinfo;
}


/**
 * Runs checks to see if urls should be converted
 *
 * @param 	boolean $dopost
 * @return 	boolean
 */
function ame_doconversion($dopost = true)
{

	global $vbulletin;
	($hook = vBulletinHook::fetch_hook('automediaembed_check_perms')) ? eval($hook) : false;
	if (!defined('AME_SKIP_PREM_CHECK'))
	{
		if ($dopost AND !(intval($_POST['parseame'] || intval($_POST['ajax']))))
		{
			if (THIS_SCRIPT == 'group')
			{
				if ($vbulletin->GPC['fromquickcomment'] && $_POST['do'] == 'message')
				{
					//nothing?
				}
				else 
				{
					return false;
				}
			}
			else 
			{
				return false;
			}
		}

		if ($vbulletin->options['automediaembed_disable'])
		{
			return false;
		}

		if ($vbulletin->options['automediaembed_usergroups'])
		{
			$check = explode(",", $vbulletin->options['automediaembed_usergroups']);

			$against = explode(",", $vbulletin->userinfo['membergroupids']);
			$against[] = $vbulletin->userinfo['usergroupid'];

			if (sizeof(array_intersect($check, $against)))
			{
				return false;
			}
		}
	}
	
	if (!$vbulletin->options['automediaembed_doblogs'])
	{
		if (THIS_SCRIPT == 'blog_post')
		{
			return false;
		}
	}
	
	if (!$vbulletin->options['automediaembed_dovms'])
	{
		if (THIS_SCRIPT == 'visitormessage')
		{
			return false;
		}
	}	

	if (!$vbulletin->options['automediaembed_dogroups'])
	{
		if (THIS_SCRIPT == 'group')
		{
			return false;
		}
	}	
	
	global $forumid;
	
	if (!$vbulletin->options['automediaembed_doforums'] AND $forumid)
	{
		return false;
	}
	
	
	
	if ($vbulletin->options['automediaembed_forumids'])
	{
		

		if ($forumid)
		{
			$check = "," . $vbulletin->options['automediaembed_forumids'] . ",";
			if (strpos($check, ",$forumid,") !== false)
			{
				return false;
			}
		}
	}
		
	return true;

}

/**
 * Parses text and replaces with [ame] bbcode
 *
 * @param	string	$text is a reference to the text getting parsed
 * @param	array	$ameinfo a key value pair of replacements. Optional
 * @return	string	Reference to parsed text
 */
function ame_prep_text(&$text)
{

	$flag = 0;

	($hook = vBulletinHook::fetch_hook('automediaembed_prep_text_start')) ? eval($hook) : false;
	if (!ame_doconversion())
	{
		$flag = 2;
	}
	else
	{

		if (!sizeof($ameinfo))
		{
			$ameinfo = fetch_full_ameinfo(true);
		}

		$substitutes = array(
			'%\[quote([^\]]*)\](.*?)\[/quote\]%sime',
			'%\[php\](.*?)\[/php\]%sime',
			'%\[html\](.*?)\[/html\]%sime',
			'%\[code\](.*?)\[/code\]%sime',
		);

		$subhandlers = array(
			'ame_substitute(1, \'\1\', \'\2\', $subbed)',
			'ame_substitute(2, \'\1\', \'\2\', $subbed)',
			'ame_substitute(3, \'\1\', \'\2\', $subbed)',
			'ame_substitute(4, \'\1\', \'\2\', $subbed)',
		);

		$subbed = array();

		if (sizeof($ameinfo))
		{
			$text = preg_replace($substitutes, $subhandlers, $text);
			$text = preg_replace($ameinfo['find'], $ameinfo['replace'], $text);
		}

		if (sizeof($subbed))
		{
			$text = preg_replace('/<<<@!([0-9]+)!@>>>/sme', 'ame_unsubstitute(\'\\1\',$subbed)', $text);
		}

		if (strpos($text, "[/ame]") !== false)
		{
			$flag = 1;
		}

	}
	($hook = vBulletinHook::fetch_hook('automediaembed_prep_text_end')) ? eval($hook) : false;

	return $flag;
}

/**
 * Replaces certain bbcode with placeholders until parsing is done
 *
 * @param	int		$typeid a flag. 1=quote 2=php 3=html 4=code
 * @param	string	$ref1 a backref
 * @param	string	$ref2 a backref
 * @param	array	$array local ref to array that holds reveral info
 * @return	string	placeholder
 */
function ame_substitute($typeid, $ref1, $ref2, &$array)
{
	static $i;
	$i++;

	$ref1 = str_replace("\\\"", '"', $ref1);
	$ref2 = str_replace("\\\"", '"', $ref2);

	if ($typeid == 1)
	{
		$ref2 = ame_strip($ref2);
		$array[$i] = "[quote$ref1]$ref2" ."[/quote]";
	}
	else
	{
		$ref1 = ame_strip($ref1);
		if ($typeid == 2)
		{
			$array[$i] = "[php]" . $ref1 . "[/php]";
		}
		else if ($typeid == 3)
		{
			$array[$i] = "[html]" . $ref1 . "[/html]";
		}
		else if ($typeid == 4)
		{
			$array[$i] = "[code]" . $ref1 . "[/code]";
		}
	}

	if ($array[$i])
	{
		return "<<<@!$i!@>>>";
	}

}

/**
 * Returns data to placeholders
 *
 * @param	string	$item = the placeholder
 * @param	array	$array of placeholders
 * @return	string	original BBcode
 */
function ame_unsubstitute($item, &$array)
{
	return $array[$item];
}

/**
 * Straight forward swap of url and ame tags.
 *
 * @param unknown_type $text
 * @param unknown_type $ameinfo
 * @return unknown
 */
function ame_match($param1, $param2, $resolve, $embedregexp, &$ameinfo)
{
	static $bini, $bok;

	if (!$bini)
	{
		global $vbulletin;
		$bok = $vbulletin->options['automediaembed_resolve'];
		$bini = true;
	}

	if (!$bok AND $embedregexp)
	{
		return $param1;
	}

	if ($bok AND $embedregexp AND $param2)
	{
		preg_match('~\\[url=?"?(.*)"?\](.*)\[/url\]~sim', $param1, $match);
		$param2 = null;
		$param1 = ($match[1] ? $match[1] : $match[2]);
		if (strrpos($param1, '"'))
		{
			$param1 = substr($param1, 0, (strlen($param1) -1));
		}
	}

	if (!$param2 && $bok && $resolve)
	{
		$param1 = str_replace(array("[url]", "[URL]", "[/url]", "[/URL]"), array("","","",""), $param1);

		$www = @file_get_contents(str_replace(array("[url]", "[URL]", "[/url]", "[/URL]"), array("","","",""), $param1));
		if ($www)
		{
			$title = ame_fetch_www_title($www);
		}

		if ($embedregexp)
		{
			$extras = ame_extract_embed($www, $embedregexp);
			if ($extras)
			{
				$title .= $extras;
			}

		}

		if ($title)
		{
			return "[ame=\"$param1\"]$title" . "[/ame]";
		}
		else
		{
			return "[ame]$param1" . "[/ame]";
		}
	}

	return str_replace(array("[url", "[/url]", "[URL", "[/URL]"), array("[ame", "[/ame]", "[ame", "[/ame]"), stripslashes($param1));
}


/**
 *	Parses the contents of a web page to return the title
 *	@param string web site
 *
 */
function ame_fetch_www_title(&$content)
{

	if(preg_match("|<[\s]*title[\s]*>([^<]+)<[\s]*/[\s]*title[\s]*>|Ui", $content, $match))
	{
		$title = trim(str_replace(array("\t","\n"), "", $match[1]));
		$title = utf8_decode($title);
        return $title;
	}
	else
	{
		return false;
	}
}

/**
 * Extracts embed code based on items embed regexp
 *
 * @param unknown_type $content
 * @param unknown_type $regexp
 * @return unknown
 */

function ame_extract_embed(&$content, &$regexp)
{
	if (!$regexp)
	{
		return;
	}

	if(preg_match($regexp, $content, $match))
	{
		if (is_array($match))
		{
			foreach($match as $key => $value)
			{
				$return .= "@@AMEPARAM@@" . trim(str_replace(array("\t","\n"), "", $value));
			}
			return $return;
		}
		else
		{
			return false;
		}

	}
	else
	{
		return false;
	}
}

/**
 * Parses bbcode but only if it is being shown... NOT in the editor
 *
 * @param unknown_type $parser
 * @param unknown_type $text
 * @param unknown_type $id
 * @return unknown
 */
function ame_process_bbcode(&$parser, &$param1, $param2 = '')
{

	if (class_exists('vB_BbCodeParser_Wysiwyg') AND is_a($parser, 'vB_BbCodeParser_Wysiwyg'))
	{
		return $text;
	}
	else
	{
		global $vbulletin;
		($hook = vBulletinHook::fetch_hook('automediaembed_parse_bbcode_start')) ? eval($hook) : false;
		$ameinfo = fetch_full_ameinfo();


		$text = preg_replace($ameinfo['find'], $ameinfo['replace'], ($param2 ? $param2 : $param1), 1);

		($hook = vBulletinHook::fetch_hook('automediaembed_parse_bbcode_end')) ? eval($hook) : false;
		return $text;
	}
}

function ame_match_bbcode($param1, $param2 = '', $title = '', $container = false, $code = '', $p0 = '', $p1 = '', $p2 = '', $p3 = '', $p4 = '', $p5 = '')
{
	global $vbulletin;

	$position = strpos($param1, "@@AMEPARAM@@");
	if ($position !== false)
	{
		$params = substr($param1, $position + 12);
		$param1 = substr($param1, 0, $position);
		$params = explode("@@AMEPARAM@@", $params);

		if (is_array($params))
		{
			foreach($params as $key => $value)
			{
				eval('$p' . $key . '=\'' . addslashes($value) . '\';');
			}
		}
	}

	if (!$param2)
	{
		$url = $param1;

		if ($container)
		{
			eval('$return = "' . addslashes($vbulletin->options['automediaembed_open']) . $code . addslashes($vbulletin->options['automediaembed_close']) . '";');
		}
		else
		{
			eval('$return = "' . $code . '";');
		}
	}
	else
	{

		$title 	= $param1;
		$url	= $param2;

		if ($vbulletin->options['automediaembed_limit'])
		{
			if (strlen($title) > $vbulletin->options['automediaembed_limit'])
			{
				if (function_exists('fetch_trimmed_title'))
				{
					$title = fetch_trimmed_title($title, $vbulletin->options['automediaembed_limit']);
				}
			}
		}

		if ($container)
		{
			eval('$return = "' .addslashes($vbulletin->options['automediaembed_open']) . $code . addslashes($vbulletin->options['automediaembed_close']) . '";');

		}
		else
		{
			eval('$return = "' . $code . '";');
		}
	}

	return stripslashes($return);
}

/**
 * Prints the disable checkbox at bottom of editor
 *
 */

function ame_disable_option()
{
	global $show, $vbulletin, $checked, $vbphrase;

	if (!ame_doconversion(false))
	{
		return;
	}

	$hooked = "\$vbphrase[automatically_parse_links_in_text]</label></div>";

	($hook = vBulletinHook::fetch_hook('automediaembed_disable_option_start')) ? eval($hook) : false;

	if ($vbulletin->templatecache['newthread'])
	{
		$name = "newthread";
		$checked['parseame'] = "checked=\"checked\"";
	}
	else if ($vbulletin->templatecache['newreply'])
	{
		$name = "newreply";
		$checked['parseame'] = "checked=\"checked\"";
	}
	else if ($vbulletin->templatecache['editpost'])
	{
		global $postinfo;
		$name = "editpost";
		$checked['parseame'] = ($postinfo['ame_flag'] != 2 ? "checked=\"checked\"" : "");
	}
	else if ($vbulletin->templatecache['socialgroups_editor'])
	{
		$name = "socialgroups_editor";
		$checked['parseame'] = "checked=\"checked\"";
	}
	else if ($vbulletin->templatecache['blog_comment_editor'])
	{
		global $bloginfo;
		$name = "blog_comment_editor";
		$checked['parseame'] = "checked=\"checked\"";
		$checked['parseame'] = ($bloginfo['ame_flag'] != 2 ? "checked=\"checked\"" : "");
	}
	else if ($vbulletin->templatecache['blog_entry_editor'])
	{
		global $bloginfo;
		$name = "blog_entry_editor";
		$hooked = "\$vbphrase[automatically_parse_links_in_text]</label>";
		$pre = "";
		$checked['parseame'] = ($bloginfo['ame_flag'] != 2 ? "checked=\"checked\"" : "");
	}
	else if ($vbulletin->templatecache['visitormessage_editor'])
	{
		global $message;
		$name = "visitormessage_editor";
		$hooked = "\$vbphrase[automatically_parse_links_in_text]</label>";
		$pre = "";
		$checked['parseame'] = ($message['ame_flag'] != 2 ? "checked=\"checked\"" : "");
	}		

	$vbulletin->templatecache["$name"] = str_replace($hooked, $hooked . $pre . '<div><label for=\"cb_parseame\"><input type=\"checkbox\" name=\"parseame\" value=\"1\" id=\"cb_parseame\" tabindex=\"1\" $checked[parseame] />$vbphrase[automediaembed_disable_ame]</label>' . $post, $vbulletin->templatecache["$name"]);

	($hook = vBulletinHook::fetch_hook('automediaembed_disable_option_end')) ? eval($hook) : false;
}


?>